#include <bits/stdc++.h>
using namespace std;

class RandomizedCollection
{
public:
    vector<int> nums;
    unordered_map<int, unordered_set<int>> numsIndex;
    int size;
    /** Initialize your data structure here. */
    RandomizedCollection()
    {
        size = 0;
    }

    /** Inserts a value to the collection. Returns true if the collection did not already contain the specified element. */
    bool insert(int val)
    {
        nums.push_back(val);
        numsIndex[val].insert(size);
        size++;
        return numsIndex[val].size() == 1;
    }

    /** Removes a value from the collection. Returns true if the collection contained the specified element. */
    bool remove(int val)
    {
        if (numsIndex.count(val) == 0)
            return false;
        int last = nums.back();
        int id = size - 1;
        if (last != val)
        {
            id = *(numsIndex[val].begin());
            numsIndex[last].erase(size - 1);
            numsIndex[last].insert(id);
            nums[id] = last;
        }
        nums.pop_back();
        size--;
        numsIndex[val].erase(id);
        if (numsIndex[val].empty())
            numsIndex.erase(val);
        return true;
    }

    /** Get a random element from the collection. */
    int getRandom()
    {
        return nums[random() % size];
    }
};

/**
 * Your RandomizedCollection object will be instantiated and called as such:
 * RandomizedCollection* obj = new RandomizedCollection();
 * bool param_1 = obj->insert(val);
 * bool param_2 = obj->remove(val);
 * int param_3 = obj->getRandom();
 */
